<?php
/* --------------------------------------------------------------
   SeoTagsDataProviderDecoratorInterface.php 2025-09-11
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);


namespace Gambio\Admin\Modules\SeoTags\Interfaces;

interface SeoTagsDataProviderDecoratorInterface
{
    
    /**
     * @return array<int,string>
     */
    public function getExcludeGetParams(): array;
    
    
    /**
     * @return array<int,string>
     */
    public function getNoIndexKeys(): array;
    
    
    /**
     * @return array<string, array<int,string>>
     */
    public function getNoIndexKeysPerPageType(): array;
    
    
    /**
     * @return array
     */
    public function getNoFollowKeysPerPageType(): array;
    
    
    /**
     * @return array
     */
    public function getNoRelPrevNext(): array;
    
    
    /**
     * @return array
     */
    public function getNoCanonicalFiles(): array;
    
    
    /**
     * @return array
     */
    public function getNoIndexFiles(): array;
    
    
    /**
     * @return array
     */
    public function getExcludeKeysFromCanonical(): array;
    
    
    /**
     * @return array
     */
    public function getExcludeKeysFromCanonicalPerPageType(): array;
    
    
}